var darkMode = false;
if (localStorage.getItem('theme') === 'dark') {
    darkMode = true;
} else if (localStorage.getItem('theme') === 'light') {
    darkMode = false;
}
if (darkMode) {
    document.body.classList.toggle('dark');
}

document.addEventListener('DOMContentLoaded', () => {
	const themeButtons = document.querySelectorAll('.theme-toggle');

	themeButtons.forEach(button => {
			button.addEventListener('click', () => {
					document.body.classList.toggle('dark');
					localStorage.setItem('theme', document.body.classList.contains('dark') ? 'dark' : 'light');
			});
	});
});
